/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id:  $:

  Description:
    Implemnation of the Connector dialog

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------

    2006-07-25  initial version

**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file ConnectorDlg.cpp
///  Implemnation of the Connector dialog
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "cifXTest.h"
#include "CIFxErrors.h"
#include "ConnectorDlg.h"
#include ".\connectordlg.h"
#include "ConnectorAPI.h"
#include <io.h>

// CConnectorDlg dialog

IMPLEMENT_DYNAMIC(CConnectorDlg, CDialog)
CConnectorDlg::CConnectorDlg(CCifXAPIlib* pcCifXAPI, CWnd* pParent /*=NULL*/)
	: CDialog(CConnectorDlg::IDD, pParent)
  , m_pcCifXAPI(pcCifXAPI)
  , m_iItemCnt(0)
  , m_bSaveChanges(false)
{
}

CConnectorDlg::~CConnectorDlg()
{
  unsigned long          ulConnectorIdx         = 0;
  NXCON_CONNECTOR_INFO_T tConnector             = {0};

  while ( NXAPI_NO_ERROR == m_pcCifXAPI->nxConEnumerate(ulConnectorIdx, sizeof(tConnector), &tConnector))
  {
    m_pcCifXAPI->nxConCloseConfigDialog(tConnector.szConnectorUUID, m_bSaveChanges);
    ulConnectorIdx++;
  }
  m_cvConnectorList.clear();
}

void CConnectorDlg::DoDataExchange(CDataExchange* pDX)
{
  CDialog::DoDataExchange(pDX);
  DDX_Control(pDX, IDC_CONFIGTAB, m_cTabCtrl);
}


BEGIN_MESSAGE_MAP(CConnectorDlg, CDialog)
  ON_BN_CLICKED(IDOK, OnBnClickedOK)
  ON_NOTIFY(TCN_SELCHANGE, IDC_CONFIGTAB, OnTcnSelchangeConfigtab)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
/// First time dialog initialization
///   \return TRUE
/////////////////////////////////////////////////////////////////////////////
BOOL CConnectorDlg::OnInitDialog()
{
  /* Hide static to notify about missing connector GUI */
  //m_cNoDialogAvailable.ShowWindow(SW_HIDE);
  CDialog::OnInitDialog();

  unsigned long          ulConnectorIdx         = 0;
  NXCON_CONNECTOR_INFO_T tConnector             = {0};

  while ( NXAPI_NO_ERROR == m_pcCifXAPI->nxConEnumerate(ulConnectorIdx++, sizeof(tConnector), &tConnector))
  {
    void* hDlgWnd = NULL;
    if (NXAPI_NO_ERROR == m_pcCifXAPI->nxConCreateConfigDialog(tConnector.szConnectorUUID, m_hWnd, &hDlgWnd))
    {
      /* Assign connector dialog to tab control */
      InsertItem(tConnector.szDescription, (HWND)hDlgWnd);
      m_cvConnectorList.push_back(tConnector);
    }  else
    {
      /* Connector does not provide a GUI -> empty tab */
      //hDlgWnd = m_cNoDialogAvailable.m_hWnd;
      //InsertItem(tConnector.szDescription, (HWND)hDlgWnd);
    }
  }

  /* Populate Tab control with connector dialogs */
  OnTcnSelchangeConfigtab(NULL, NULL);

  return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
/// Insert item into tab control
///   \param lpszItem Name of tab item
///   \param hDlg     Window handle of tab item
/////////////////////////////////////////////////////////////////////////////
void CConnectorDlg::InsertItem(LPCTSTR lpszItem, HWND hDlg)
{
  m_cTabCtrl.InsertItem(m_iItemCnt, lpszItem);
  m_cvHwnd.push_back(hDlg);
  m_iItemCnt++;
}

// CConnectorDlg message handlers
void CConnectorDlg::OnBnClickedOK()
{
  m_bSaveChanges = true;
  EndDialog(IDOK);
}

void CConnectorDlg::OnTcnSelchangeConfigtab(NMHDR *pNMHDR, LRESULT *pResult)
{
	UNREFERENCED_PARAMETER(pNMHDR);
  unsigned int nSel;

  if (0 > (nSel = m_cTabCtrl.GetCurSel()))
    return;

  if (m_cvHwnd.empty() || (m_cvHwnd.size()<nSel))
    return;

	if(m_cvHwnd[nSel])
  {
    ::ShowWindow(m_cvHwnd[nSel], SW_HIDE);
  }
	CRect l_rectClient;
	CRect l_rectWnd;

  /* Retrieves the coordinates of a tabctrl client area, relative to the 
     upper-left corner of the tabctrl client area */
  m_cTabCtrl.GetClientRect(l_rectClient);
	
  /* Calculate the tabctrl display area given the window rectangle */
  m_cTabCtrl.AdjustRect(FALSE,l_rectClient);
  
  /* Retrieves the dimensions of the bounding rectangle of the tabctrl window,
     relative to the upper-left corner of the screen. */
  m_cTabCtrl.GetWindowRect(l_rectWnd);
  
  /* Convert the screen coordinates of the rectangle on the display 
     to client coordinates.	*/
  ScreenToClient(l_rectWnd);

  /* Move the rectangle by the retrieved offsets */
	l_rectClient.OffsetRect(l_rectWnd.left,l_rectWnd.top);
	
  for(std::vector<HWND>::iterator iterDialogs = m_cvHwnd.begin(); iterDialogs != m_cvHwnd.end(); ++iterDialogs)
  {
    ::SetWindowPos(*iterDialogs, wndTop.m_hWnd, l_rectClient.left,l_rectClient.top,l_rectClient.Width(),l_rectClient.Height(),SWP_HIDEWINDOW);
  }
  ::SetWindowPos(m_cvHwnd[nSel], wndTop.m_hWnd,l_rectClient.left,l_rectClient.top,l_rectClient.Width(),l_rectClient.Height(),SWP_SHOWWINDOW);  
  
  if (pResult)
    *pResult = 0;
}
